#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define DEBUG
#undef DEBUG

#define MAXLINE 1024		/* max. no. of characters per line */
#define MAXREC (20*MAXLINE)	/* max. no. of characters per record */

#define DELIMITER ','		/* delimiter character */

char *progname;
char *infilename;
int linenumber;

char record_buffer[MAXREC];	/* buffer for a record consisting of
				   several lines */
char *rec_ptr;

char wstring[MAXLINE];		/* holds the line of key words */

main(argc, argv)
     int argc;
     char *argv[];
{
  FILE *fp, *fopen();

  rec_ptr = record_buffer;
  progname = argv[0];
  if (argc == 1) {		/* without arguments: */
    infilename = NULL;
    filebylines(stdin);		/* hack standard input */
  }
  else
    while (--argc > 0)
      if ((fp = fopen(*++argv, "r")) == NULL) {
	fprintf(stderr,
		"%s: can't open %s\n", progname, *argv);
	exit(1);
      } else {
	infilename = *argv;
	filebylines(fp);
	fclose(fp);
      }
  exit(0);
}
	
filebylines(fp)			/* pass each line of file fp to a function */
     FILE *fp;
{
  char s[MAXLINE];		/* buffer for one line of input */

  linenumber = 0;
  while (fgets(s, MAXLINE, fp) != NULL) {
    linenumber++;
#ifdef DEBUG
    printf("##filebylines: line %d: ``%s''\n", linenumber, s);
#endif
    linehack(s);
  }
  write_records();	/* to write out the last record, if the file */
  			/* does not end with an empty line */
}

linehack(s)		/* accumulate line s of a record into rec_ptr */
     char *s;
{
  char tibfield();

#ifdef DEBUG
  printf("##tibfield(%s) = %c\n", s, tibfield(s));
#endif  
  switch (tibfield(s)){
  case 'W':			/* a key word line */
#ifdef DEBUG
      printf("Saving `%s' in wstring.\n", s);
#endif
    strcpy(wstring, s);		/* save it for write_records */
    break;
  case '0':			/* an empty line means end of this record */
    write_records();
    break;
  case '1':			/* other lines, maybe continuation lines */
    append_to_record_buffer(s);
    break;
  default:
    fprintf(stderr, "switch fall through in linehack: internal error!\n");
    break;
  }
}

char tibfield(s)			/* return type (tib field tag) of s */
     char *s;
{
  if (strcmp(s,"\n") == 0)	/* empty line got by fgets contains \n only */
    return('0');
  if (strlen(s) >= 2 && s[0] == '%' & s[1] == 'W')
      return('W');
  return('1');			/* neither empty nor %W line*/
}

write_records()	/* split line wstring into key words and output as
			   many copies of record_buffer as there are key
			   words. */
{
  char *s;
  char *swort;
  char c;

#ifdef DEBUG
  printf("##write_records: splitting `%s'\n", wstring);
#endif
  s = wstring;
  if (*s == '\0'){		/* s is empty if there was no %W line in this
				   record */
    reset_rec_ptr();		/* Throw away records without key word.
				   BUG FIX 89/3/9 sk
				   [left overs got into the next record] */
    return;
  }
  
  if (*s != '%') {
    fprintf(stderr,
	    "Wrong call to write_records - in line %d `%%' expected.\n",
	    linenumber);
  }
  s++;				/* advance over `%' ... */
  while (*s){
    while (isspace(*++s))	/* ... over W or DELIMITER from last iteration
				   and over white space */
      ;
    swort = s;			/* start of key word in s */
    while ((c = *s) != DELIMITER && c != '\n' && c != '\0') {
      s++;
    }
    *s = '\0';			/* put end of key where DELIMITER or \n was */
    if (strlen(swort)!= 0) {	/* the last key word is always empty */
#ifdef DEBUG
      printf("##write_records: outputting one copy for key `%s'\n", swort);
#endif
      printf("%%W %s\n", swort);
      printf("%s\n", record_buffer);
    }
    *s = c;			/* ready for next key word */
  }				/* all key words processed */
  wstring[0] = '\0';		/* so that succesive empty lines are
				   suppressed */
  reset_rec_ptr();
}

append_to_record_buffer(s)
     char *s;
{

#ifdef DEBUG
      printf("##append_to_record_buffer: `%s'\n", s);
#endif
  strcpy(rec_ptr, s);	/* append this line to the record buffer */
  rec_ptr += strlen(s);	/* ready for next append */

}

reset_rec_ptr()
{
#ifdef DEBUG
  printf("write_records: resetting rec_ptr.\n");
#endif
  rec_ptr = record_buffer; /* ready for next record */
}
