/* TO_SJIS.C is Copyright 1990 Humanities and Arts Computing Center */
/* may be used under the terms of HACC software general public license */
/* see the file license for details */
/* usage: to_sjis inputfilename outputfilename */
/* convert escape sequence tagged JIS codes to 8-bit JIS codes */
/* Kanji-In sequences accepted are <ESC>$@ <ESC>$B or <ESC>K */
/* Kanji-out sequences accepted are <ESC>(J <ESC>(B or <ESC>H */
/* suggestions to ridgeway@u.washington.edu */
#include <stdio.h>
/* make the meaning of byte known to C */
typedef unsigned char byte;

/* globally accessible data */
char output[128], input[128];  /* buffers for file names */
char *progname;  /* the name of this program */
FILE *outfile,*infile; /* the input and output files */

void charout(char thischar)
{
  putc(thischar,outfile);
}

void copyright()
{
  puts("TO_SJIS  7-bit to 8-bit JIS converter.\n");
  puts("HUMANITIES AND ARTS COMPUTING CENTER, DR-10");
  puts("UNIVERSITY OF WASHINGTON, SEATTLE WA 98195 USA\n");
  puts("Copyright 1990 Humanities and Arts Computing Center\n");
  puts("This software may be used, modified, and redistributed free of any");
  puts("fee or royalty, provided that this copyright and 'free software' notice");
  puts("remains intact in any copies redistributed, and that you may charge no fee");
  puts("of any sort whatsoever without the written permission of the Humanities");
  puts("and Arts Computing Center.");
  return;
}

jumpout(int errcode)
/* immediate exit */
{
 exit(errcode);
}

/* see whether a file of that name already exists */
void exists (FILE *handle, char *filename) 
  { 
    unsigned char response;
    handle = fopen ( filename , "rb" ) ; 
    if (handle != NULL) 
       {  fclose(handle);
          printf("File %s already exists: O.K. to replace? (Y/N): ", filename);
          response = getchar();
          if ( ! ( (response=='y') || (response=='Y') ) ) 
            {
            printf("\nPlease rename files as necessary and try again.\n");
            jumpout(3);
            }
       }
    return;
    } 

/* open a file with some access */
FILE *getopen(char *filename, char *access)
{
	int	temp;
	FILE	*handle;
	gets(filename);
	if (access[0]=='w' || access[0]=='W') exists(handle,filename);
	handle=fopen(filename,access);
	if (handle == NULL) {
	  puts("\nCan't open file ");
	  puts(filename);
	  puts("\n");
	  }
	return handle;
}

/* prompt for and open a file */
FILE *get_file(char *access,char *prompt,char *filename)
{
	printf("\n %s",prompt);
	return getopen(filename,access);
}

/* quick open of the inputfile */
openinfile () 
{ 
    infile = fopen ( input , "rb" ) ; 
    if (infile == NULL) 
       {  printf("%s: Unable to open %s; exiting on error.\n",progname,input);
          jumpout(4);
       }
} 

/* quick open of the output file */
openoutfile () 
{ 
    exists(outfile,output);  
    outfile = fopen ( output , "wb" ) ; 
    if (outfile == NULL) 
       {  printf("%s: Unable to open %s; exiting on error.\n",progname, output);
          jumpout(5);
       }
} 


/* get a memory block and test that it was obtained */
void *getmemblk(unsigned int blocksize)
{  
  void *thisblock;
  thisblock=(void *) malloc(blocksize);
  if (thisblock==NULL) {
     printf("\n%s: !Failure while attempting to allocate %ud bytes of memory.",progname,blocksize);
     printf("\n . . . aborting . . .\n");
     exit(1);
     }
  return thisblock;
}

void stringout(char *thisstring)
{
  fputs(thisstring,outfile);
}

void intout(int thisone)
{
  fprintf(outfile,"%d",thisone);
}

void uintout(unsigned int thisone)
{
  fprintf(outfile,"%ud",thisone);
}

void newlineout()
{
  stringout("\n");
}

main(int argc, char *argv[])
{
  int ch,err,jflag;
  jflag=0;
  copyright();
  progname = "TO_SJIS";
  if (argc > 1)  {
      strcpy ( input , argv [ 1 ] ) ;
      openinfile();
      }
   else {
     infile=get_file("r","Enter input filename: ",input);
     }
  if (argc > 2)  {
     strcpy ( output , argv [ 2 ] ) ;
     openoutfile();
     }
   else {
        outfile=get_file("w","Enter output filename: ",output);
        }
   while ((ch = getc(infile)) != EOF) {
     if  (ch == 27) {
	    ch = getc(infile);
            if (jflag) {
               if (ch == '(') {
		  ch = getc(infile);
                  if (ch == 'J' || ch == 'B') jflag=0;
                  else {
                    putc(27,outfile);
                    putc('(',outfile);
                    putc(ch,outfile);
                  }
               }
               else {
                 if (ch == 'H') jflag=0;
                 else {
                   putc(27,outfile);
                   putc(ch,outfile);
                 }
               }
            }
            else {
               if (ch == '$') {
		  ch = getc(infile);
                  if (ch == '@' || ch == 'B') jflag=1;
                  else {
                    putc(27,outfile);
                    putc('$',outfile);
                    putc(ch,outfile);
                  }
               }
               else {
                 if (ch == 'K') jflag=1;
                 else {
                   putc(27,outfile);
                   putc(ch,outfile);
                 }
               }
            }
      }
      else {
        if (jflag) putc(ch+128,outfile);
        else putc(ch,outfile);
      }
   }   
   printf("\n\nTO_SJIS complete.\n");
   fclose(infile);
   fclose(outfile);
}
