/* pl.c --- part of pbmtogf program

Copyright (C) 1998 Wai Wong

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  

Version 0.1 1998/03/31 Initial version
Version 1.0 1999/03/25 First public release version
*/

#include <stdio.h>
#include <string.h>

#define EXTERN extern
#include "pbmtogf.h"

char UNSPEC[] =       "UNSPECIFIED";
char COMMENT[] =      "COMMENT";
char CHECKSUM[] =     "CHECKSUM";
char DESIGNSIZE[] =   "DESIGNSIZE";
char DESIGNUNITS[] =   "DESIGNUNITS";
char CODINGSCHEME[] = "CODINGSCHEME";
char FAMILY[] =       "FAMILY";
char FACE[] =         "FACE";
char FONTDIMEN[] =    "FONTDIMEN";
char CHARACTER[] =    "CHARACTER";

char CHAR[] = "C";
char DEC[] =  "D";
char OCT[] =  "O";
char HEX[] =  "H";
char REAL[] = "R";

void write_pl(FILE *ofile)
{
  int i;

  /* signature */
  fprintf(ofile, "(%s Created by %s, version %s)\n",
	  COMMENT, progname, version);
  /* the length of the family name must be less than 20 */
  fprintf(ofile, "(%s %s)\n", FAMILY, UNSPEC); 
  /* the length of the coding scheme name must be less than 40 */
  fprintf(ofile, "(%s %s)\n", CODINGSCHEME, UNSPEC);

  fprintf(ofile, "(%s %s %d)\n", DESIGNSIZE, DEC, (short)design_size);
  fprintf(ofile, "(%s %s %d)\n", DESIGNUNITS, DEC,
	  (unsigned short)(0.5 + ((res * design_size) /72.27)));
  fprintf(ofile, "(%s %s %X)\n", CHECKSUM, HEX, checksum);

  for(i = ccode1; i < (ccode1+ccode2); i++){
      fprintf(ofile, "(%s %s %d\n", CHARACTER, DEC, i);
      fprintf(ofile, "  (CHARWD D %d)\n", ch_wid);
      fprintf(ofile, "  (CHARHT D %d)\n", ch_ht);
      fprintf(ofile, "  (CHARDP D 0)\n  )");
  }  

}/* end of write_pl () */
