/* @(#)suninteract.c	1.11 2/18/87 */
#include "header.h"
#include <suntool/sunview.h>
#include <suntool/icon.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
static short icon_data []={
#include "dvisuntool.icon"
};
mpr_static (icon_pixrect, 64, 64, 1, icon_data);
struct pixrect *panel_button_image ();
int set_mode;	/* default modes */
int clr_mode;
int draw_mode; 
struct pixwin *screen; /* Object to display graphics on. */
Canvas canvas; /* Canvas we are displaying graphics on. */

Panel_item warning_message_item; /* Place to put warning messages. */
Panel_item filename_item; /* Thing to read file names with. */
Panel_item page_slider; /* Slider on the display for paging the */
			/* document.*/ 
void refresh_proc ();

/* Draw a black box on the screen. */
void black_box (x, y, width, height)
     int x,y,width,height;
{
  pw_rop (screen, x, y, width, height,
	  set_mode, NULL, 0, 0);
}  

int screen_height ()
{
  return ((int) window_get (canvas, CANVAS_HEIGHT));
}

/* Read a character image starting at the current pointer of the given */
 /* file.  Width is the width in pixels of the object, height is the */
/* height in pixels of the object. */
/* For Suntools, a CharImage is really a pixrect pointer. */
CharImage read_char (pxlfp, width, height)
     FILE *pxlfp;
     int width, height;
{
  register int nshorts, i, col, nints;
  register short *dp, *sp;
  static int buffer[8];
  register struct pixrect *pr;

  nshorts = (width + 15) >> 4;
  pr = mem_create(width, height, 1);
  nints = (nshorts + 1) >> 1;
  dp = ((struct mpr_data *)pr->pr_data)->md_image;
  for (col = 0; col < height; col++) {
    fread(buffer, 4, nints, pxlfp);
    sp = (short *) &buffer[0];
    for (i = nshorts; i > 0; i--) *dp++ = *sp++;
  }
  return ((CharImage) pr);
}

void show_char (x, y, width, height, image)
     int x, y, width, height;
     CharImage image;
{
  pw_rop(screen, x, y, width, height, draw_mode,
	 (struct pixrect *)image, 0, 0);
}

void clearscreen ()
{
  pw_rop(screen, 0, 0,
	 (int) window_get (canvas, CANVAS_WIDTH),
	 (int) window_get (canvas, CANVAS_HEIGHT),
	 clr_mode, NULL, 0, 0);
}

/* Update the number on the page number slider to n. */
void update_slider (n)
     int n;
{
  panel_set_value (page_slider, n);
}

/* Update the number of pages on the slider, and don't display it at */
 /* all in trivial cases. */ 
void show_slider (pages)
     int pages;
{
  if (pages > 1) {
    panel_set (page_slider,
	       PANEL_MAX_VALUE, pages,
	       PANEL_SHOW_ITEM, TRUE,
	       0);
  } else {
    panel_set (page_slider, PANEL_SHOW_ITEM, FALSE, 0);
  };
}

void lock_canvas ()
{
  struct rect r;

  pw_get_region_rect (screen, &r);
  pw_lock (screen, &r);
}

void unlock_canvas ()
{
  pw_unlock (screen);
}

void showerror (string)
     char *string;
{
  panel_set (warning_message_item, PANEL_LABEL_STRING, string, 0);
}

void clearerror ()
{
  panel_set (warning_message_item, PANEL_LABEL_STRING, "", 0);
}

void page_proc (item, value, event)
     Panel_item item;
     int value;
     Event *event;
{
  goto_page (value);
};

static Panel panel;

void create_a_button (name, width, x, y, callout)
     char *name;
     int width, x, y;
     void (*callout) ();
{
  panel_create_item (panel, PANEL_BUTTON,
		     PANEL_LABEL_IMAGE,
		     panel_button_image (panel, name, width,
					 NULL),
		     PANEL_NOTIFY_PROC, callout,
		     PANEL_ITEM_X, ATTR_COL (x),
		     PANEL_ITEM_Y, ATTR_ROW (y),
		     0);
}

char *curfilename ()
{
  panel_get_value (filename_item);
}

void my_mouse_proc (window, event)
     Window window;
     Event *event;
{
  if (event_is_button (event)) {
    if (event_is_down (event)) {
      buttondown (event_x (event), event_y (event));
    } else {
      buttonup (event_x (event), event_y (event));
    };
  };
};
     

void main(argc, argv)
     int argc;
     char *argv[];
{
  Frame frame;

  frame = window_create (NULL, FRAME,
			 FRAME_LABEL, argv[0],
			 FRAME_SUBWINDOWS_ADJUSTABLE, FALSE,
			 FRAME_NO_CONFIRM, TRUE,
			 FRAME_ARGC_PTR_ARGV, &argc, argv,
			 FRAME_ICON,
			 icon_create (ICON_IMAGE, &icon_pixrect, 0),
			 0);
  /* get enviroment variables that allows for a path name in unix */
  if ((PXLpath=getenv("BGPXLPATH")) == NULL)
    PXLpath = FONTAREA;
  panel = window_create (frame, PANEL,
			 WIN_HEIGHT, ATTR_ROW (2), 0);
  filename_item = panel_create_item (panel, PANEL_TEXT,
				     PANEL_LABEL_STRING, "Filename:",
				     PANEL_VALUE_DISPLAY_LENGTH, 20,
				     0);
  warning_message_item =
    panel_create_item (panel, PANEL_MESSAGE,
		       PANEL_LABEL_STRING,
		       "                      ",
		       PANEL_ITEM_Y, ATTR_ROW (1),
		       PANEL_ITEM_X, ATTR_COL (0),
		       0);
  create_buttons ();
  page_slider = panel_create_item  (panel, PANEL_SLIDER,
				    PANEL_SHOW_VALUE, TRUE,
				    PANEL_LABEL_STRING, "Page:",
				    PANEL_NOTIFY_PROC, page_proc,
				    PANEL_NOTIFY_LEVEL, PANEL_DONE,
				    PANEL_MIN_VALUE, 1,
				    PANEL_SHOW_ITEM, FALSE,
				    PANEL_MAX_VALUE, 1, 
				    PANEL_ITEM_X, ATTR_COL (57),
				    PANEL_ITEM_Y, ATTR_ROW (0),
				    0);
  canvas = window_create (frame, CANVAS,
			  CANVAS_REPAINT_PROC, refresh_proc,
			  CANVAS_RETAINED, FALSE,
			  WIN_CONSUME_PICK_EVENT,
			  WIN_MOUSE_BUTTONS,
			  WIN_EVENT_PROC, my_mouse_proc,
			  0);
  screen = canvas_pixwin (canvas);
  set_mode = PIX_COLOR(1) | PIX_SRC; 
  clr_mode = PIX_COLOR(0) | PIX_SRC;
  draw_mode = PIX_SRC | PIX_DST;
  reset_scroll ();
  if (argv [1] != NULL) {
    panel_set_value (filename_item, argv [1]);
    load_proc ();
  }
  window_main_loop (frame);
}

#ifdef thisisametacomment
 This code used to be in here before we made this interact 
  with suntools properly.  It may be useful again someday.
#ifdef DEBUG
    case 'f':			/* fine tune y */
      ydefault = ReadInt();
      yscreen = ydefault;
      redisplay (&cpagep, &ppagep);
      break;
    case 'h':			/* fine tune hconv */
      hconv = DoConv(num, den, ReadInt());
      redisplay (&cpagep, &ppagep);
      break;
    case 'v':			/* fine tune hconv */
      vconv = DoConv(num, den, ReadInt());
      redisplay (&cpagep, &ppagep);
      break;
#endif
/* End metacomment */
#endif
