# pagesel.tcl -- GV-like page selector for TkDVI.
# Copyright  1999 Anselm Lingnau <lingnau@tm.informatik.uni-frankfurt.de>.
# See file COPYING for conditions on use and distribution.
# $Id: pagesel.tcl,v 1.1.1.1 1999/06/10 12:36:50 lingnau Exp $

package provide tkdvi::pagesel 1.0

namespace eval tkdvi::pagesel {
    variable cmd {}
    proc new {w args} {
	set w [frame $w -class Pagesel]
	upvar \#0 tkdvi::pagesel::$w state
	set c [canvas $w.c -relief sunken -borderwidth 2 -width 40 \
		-yscrollcommand [list $w.s set]]
	set s [scrollbar $w.s -orient vertical \
		-command [list $c yview]]
	grid $s $c -sticky ns
	grid rowconfigure $w 0 -weight 1
	set state(c) $c
	menu $w.popup
	$w.popup add command -label "Select all" \
		-command [namespace code [list _selectAll $w 1]]
	$w.popup add command -label "Deselect all" \
		-command [namespace code [list _selectAll $w 0]]
	$w.popup add command -label "Invert Sel" \
		-command [namespace code [list _selectAll $w -1]]
    }
    proc addpages {w pages} {
	upvar \#0 tkdvi::pagesel::$w state
	set n [llength $pages]
	set f [font create -family Helvetica -size 10]
	set h [font metrics $f -linespace]
	if {$h % 2 == 1} { incr h }
	$w.c configure -scrollregion [list 0 0 40 [expr {$n*$h}]] \
		-yscrollincrement $h
	$w.c delete all
	set y 0
	set b [$w.c cget -background]
	foreach p $pages {
	    $w.c create rectangle 2 $y 38 [expr {$y + $h - 1}] \
		    -fill $b -outline {} -tags [list touch p-$p]
	    $w.c create text 25 $y -text $p -font $f -anchor n \
		    -tags [list touch num p-$p]
	    $w.c create rectangle 4 [expr {$y+2}] 8 [expr {$y+$h-3}] \
		    -fill $b -outline {} -tags [list touch sel p-$p]
	    incr y $h
	}
	$w.c bind touch <Enter> \
		[namespace code [list _setCurrItemBg $w gray70]]
	$w.c bind touch <Leave> \
		[namespace code [list _setCurrItemBg $w $b]]
	$w.c bind touch <1> \
		[namespace code [list _execCmd $w]]
	$w.c bind touch <2> \
		[namespace code [list _toggleSel $w]]
	$w.c bind touch <ButtonPress-3> \
		[namespace code [list _popup $w %X %Y]]
	$w.c itemconfigure curr -outline black
    }
    proc _popup {w x y} {
	tk_popup $w.popup $x $y
    }
    proc _execCmd {w} {
	upvar \#0 tkdvi::pagesel::$w state
	set c $state(c)
	set t [$c gettags [$c find withtag current]]
	set t [lindex $t [lsearch -glob $t p-*]]
	set pg [string range $t 2 end]
	regsub {%p} $state(cmd) $pg execCmd
	eval $execCmd
    }
    proc _setCurrItemBg {w color} {
	upvar \#0 tkdvi::pagesel::$w state
	set c $state(c)
	set t [$c gettags [$c find withtag current]]
	set t [lindex $t [lsearch -glob $t p-*]]
	set items [$c find withtag $t]
	$c itemconfigure [lindex $items 0] -fill $color
	if {[lsearch -exact [$c gettags [lindex $items end]] x] < 0} {
	    $c itemconfigure [lindex $items end] -fill $color
	}
    }
    proc markCurrent {w item} {
	upvar \#0 tkdvi::pagesel::$w state
	set c $state(c)
	set item [expr {($item-1)*3+1}]
	if {[info exists state(curr)]} {
	    $c itemconfigure $state(curr) -outline {}
	}
	$c itemconfigure $item -outline black
	set state(curr) $item
    }
    proc _toggleSel {w {item -1}} {
	upvar \#0 tkdvi::pagesel::$w state
	set c $state(c)
	if {$item == -1} {
	    set item [$c find withtag current]
	}
	set t [$c gettags $item]
	set t [lindex $t [lsearch -glob $t p-*]]
	set i [lindex [$c find withtag $t] end]
	set iTags [$c gettags $i]
	set sel [lsearch -exact $iTags x]
	if {$sel >= 0} {
	    $c itemconfigure $i -fill [$c cget -background] \
		    -tags [lreplace $iTags $sel $sel]
	} else {
	    $c itemconfigure $i -fill red -tags [concat $iTags x]
	}
    }
    proc _selectAll {w mode} {
	upvar \#0 tkdvi::pagesel::$w state
	set c $state(c)
	
    }
    proc select {w start inc} {
    }
    proc selected {w} {
	upvar \#0 tkdvi::pagesel::$w state
	set c $state(c)
	set result {}
	foreach i [$c find withtag sel] {
	    set t [$c gettags $i]
	    if {[lsearch -exact $t x] >= 0} {
		set t [lindex $t [lsearch -glob $t p-*]]
		lappend result [string range $t 2 end]
	    }
	}
	return $result
    }
    proc command {w newCmd} {
	upvar \#0 tkdvi::pagesel::$w state
	set state(cmd) $newCmd
    }
    proc mkList {n} {
	set result {}
	for {set i 1} {$i <= $n} {incr i} { lappend result $i }
	return $result
    }
}
