/*
 *	This file contains the various postscript string definitions
 *	that are used by the symbiont.
 *
 *	The file burst, flag, and trailer pages all use macros
 *	to perform various tasks. The following is the string
 *	sent to the LaserWriter to define the macros used for:
 *
 *	pw - Printing a word if it will fit on the current
 *	     line; else move to the next line.
 *	cr - Simulating a carriage return.
 *	lf - Simulating a line feed.
 *	tab - sets horizontal position to next multiple of tabskip
 *	LM - Left Margin.
 *	RM - Right Margin.
 *	TM - Top Margin.
 *	BM - Bottom Margin.
 *	XC - X value of page center.
 *	YC - Y value of page center.
 *	tinyfont - Sets font for printing very small characters.
 *	smallfont - Sets font for printing small characters.
 *	mediumfont - Sets font for printing medium-size characters.
 *	largefont - Sets font for printing large characters.
 *	hugefont - Sets font for printing very large characters.
 *	LS - Inter-line spacing value.
 *	WS - Inter-word spacing value.
 *	cshow - 'Show's text centered at current position.
 *	crect - Draws rectangle centered at current position with
 *	        specified width, height and thickness.
 *	boxedtext - Outputs text with box around it.
 *	textrule - Outputs text followed by a rule.
 *	#copies - number of copies of each page (1).
 *	CP - currentpoint.
 *	ssf - Set scaled font.
 *	jobbox - generates the job copy box on flag pages
 *	filebox - generates the file copy box on flag pages
 *	footer - generates the footer at bottom of flag pages
 */

char *Flag_Prefix[] = {
"errordict begin/timeout{}def end 28 dict begin\
/CP{currentpoint}def\
/LM 0 0 itransform/TM exch def def\
/RM 610 LM sub def/BM 794 TM sub def BM 0 le{/BM 1010 TM sub def}if\
/XC LM RM add 2 idiv def/YC BM TM add 2 idiv def\
/cr{CP exch pop LM exch moveto}def\
/lf{0 LS neg rmoveto}def\
/tab{CP exch LM sub tabskip add 1 sub tabskip idiv tabskip mul LM add exch moveto}def\
/pw{dup stringwidth pop CP pop add RM gt{cr lf}if show WS 0 rmoveto}def\
/cshow{dup stringwidth pop -2 div LS -2.5 div rmoveto show}def\
/crect{gsave setlinewidth CP newpath moveto 1 index -2 div 1 index -2 div rmoveto \
1 index 0 rlineto 0 exch rlineto neg 0 rlineto closepath stroke grestore}def\
/boxedtext{crect cshow}def\
/textrule{show WS 0 rmoveto CP exch pop lineto 1 setlinewidth stroke}def ",
"/ssf{/LS 2 index 1.2 mul round cvi def findfont exch scalefont \
setfont/WS( )stringwidth pop def}def\
/tinyfont{7/Helvetica ssf}def\
/smallfont{12/Helvetica ssf}def\
/mediumfont{18/Helvetica ssf}def\
/largefont{27/Helvetica-Bold ssf}def\
/hugefont{48/Helvetica-Bold ssf}def ",
"/jobbox{tinyfont CP 3 index 4 div 0 exch rmoveto(Job)cshow \
2 copy moveto 3 index -4 div 0 exch rmoveto(Copy)cshow \
mediumfont moveto boxedtext}def\
/filebox{tinyfont CP 3 index 4 div 0 exch rmoveto(File)cshow \
2 copy moveto 3 index -4 div 0 exch rmoveto(Copy)cshow \
mediumfont moveto boxedtext}def\
/footer{mediumfont XC BM 30 add moveto(VAX/VMS  VAX/VMS  VAX/VMS)\
RM LM sub 6 sub 54 6 boxedtext}def\
/#copies 1 def initgraphics ",
0 };

char *Flag_Postfix[] = { " end \004", 0 };

/*
 *	The file being sent to the LaserWriter is preceded by the
 *	File_Prefix and followed by the File_Postfix. These redefine
 *	the "showpage" and "copypage" commands so that they print a
 *	message each time they are invoked. This mechanism, unfortunately,
 *	is not foolproof, since "showpage" or "copypage" can simply be
 *	redefined by a user to mix us up (in order to prevent redefinition,
 *	the dictionary containing the object must be readonly - using
 *	this would disallow the user def'ing anything). And, of course,
 *	some goofus could just print out the string we use for indicating
 *	a page is being printed, just to confuse us some more.
 *
 *	Note that this is used only to count pages (for accounting purposes),
 *	not to keep track of where a page description begins and ends; we
 *	still have the problem of identifying precisely what command caused
 *	the page to be printed.
 *
 *	Additionally, the errordict is made read-only to prevent users
 *	from modifying the error processing behavior. This is necessary
 *	in order for the symbiont to retain some level of control over
 *	the LaserWriter. Because pausing the queue can cause the
 *	LaserWriter to time out, the 'timeout' error handler is re-defined
 *	to do nothing.
 *
 *	Definition names beginning with 'SMB@' are reserved to the print
 *	symbiont. The following definitions are created by the Symbiont:
 *
 *	    SMB@numstr       Scratch string for numerics
 *	    SMB@pagesetup    Procedure done at top of each page
 *	    SMB@dopage       Internal procedure to process one page completion
 *	    SMB@pageheader   Procedure to generate page header
 */

char *File_Prefix[] = {
"errordict dup begin/timeout{}def end readonly pop\
/SMB@numstr 10 string def/SMB@pagesetup{}executeonly def\
/SMB@dopage{(\\%\\%[ Printing: )print SMB@numstr cvs print( ]\\%\\% \\n)print flush \
systemdict exch get exec SMB@pagesetup}bind executeonly def\
/showpage{/showpage #copies SMB@dopage}executeonly def\
/copypage{/copypage 1 SMB@dopage}executeonly def\
{{(%stdin)run}stopped{count 0 gt{(Operand stack:\\n)print pstack}if handleerror}if stop}exec ",
0 };

char *Manual_Feed = "statusdict begin/manualfeed true def/manualfeedtimeout 120 def end ";

char *File_Postfix[] = { " \004", 0 };

/*
 *	The next two strings bracket the definition of the page setup
 *	procedure:
 */

char *Page_Setup_Prefix[] = { "/SMB@pagesetup{", 0 };
char *Page_Setup_Postfix[] = { "}bind executeonly def ", 0 };

/*
 *	These next strings are the programs to generate burst pages.
 *	A job burst page has a series of 12 horizontal lines, and a file
 *	burst page has a series of 8 vertical lines, all 1/4" wide:
 */

char *Job_Burst[] = {
"BM 9 add TM BM sub 18 sub 11 div TM 8 sub{dup LM exch moveto RM exch lineto}for \
18 setlinewidth 0.5 setgray stroke showpage ",
0 };

char *File_Burst[] = {
"LM 9 add RM LM sub 18 sub 7 div RM 8 sub{dup BM moveto TM lineto}for \
18 setlinewidth 0.5 setgray stroke showpage ",
0 };
