/***************************************************************************
** Although considerable effort has been expended to make this software   **
** correct and reliable, no warranty is implied; the author disclaims any **
** obligation or liability for damages, including but not limited to      **
** special, indirect, or consequential damages arising out of or in       **
** connection with the use or performance of this software.               **
***************************************************************************/

/*
 *	This file contains VMS message functions.
 */

#include descrip

#include "strng.p"

/*
 *	Routine Message outputs a message to the user terminal.
 *	It takes exactly one argument, used in formatting the
 *	message by VMS's FAO service.
 */

Message (Msg_Code)
unsigned long Msg_Code;
{
	auto   unsigned long *Ptr;
	auto   int Count, Index;
	static unsigned long Arg_Value[4], Arg_Type[4];
	static struct dsc$descriptor FAO_Desc;
	static char Message_String[128], FAO_String[256];
	extern unsigned long Lib$Put_Output();
/*
 *	Obtain the message string from the system:
 */
	Get_VMS_Message (Msg_Code, Message_String, sizeof (Message_String));
/*
 *	Collect all arguments from the argument list, which is variable:
 */
	Ptr = &Msg_Code;		/* moval @4(ap); i.e. Ptr = ap+4 */
	if ((Count = Ptr[-1] - 1) > 8)
		Count = 8;
	Count >>= 1; Ptr++;
	for (Index = 0; Index < Count; Index++) {
		Arg_Value[Index] = *Ptr++;
		Arg_Type[Index] = *Ptr++;
	}
/*
 *	Format the message and output finished message to standard
 *	output:
 */
	Format_Message (Message_String, Arg_Value, Arg_Type, Count, FAO_String, sizeof (FAO_String));
	Make_VMS_Descriptor (FAO_String, &FAO_Desc);
	Lib$Put_Output (&FAO_Desc);
}

Get_VMS_Message (Msg_Code, Msg_String, Msg_String_Size)
unsigned long Msg_Code;
char *Msg_String;
unsigned short Msg_String_Size;
{
	auto   unsigned long Sys_Status;
	static struct dsc$descriptor Msg_Desc;
	static unsigned short Length;
	static char *GetMsg_Msg = "%GETMSG-X-INVALMSG, invalid message code";
	extern unsigned long Lib$Sys_GetMsg();
/*
 *	Get the message string from the system:
 */
	Set_VMS_Descriptor (Msg_String, Msg_String_Size-1, &Msg_Desc);
	Sys_Status = Lib$Sys_GetMsg (&Msg_Code, &Length, &Msg_Desc);
	if ((Sys_Status & 0x01) != 0)
		Msg_String[Length] = '\0';
	else
		stringcpy_m (Msg_String, GetMsg_Msg, Msg_String_Size);
}

Format_Message (Msg_String, Arg_Value, Arg_Type, Arg_Count, FAO_String, FAO_String_Size)
unsigned long Arg_Value[], Arg_Type[];
int Arg_Count;
char *Msg_String, *FAO_String;
unsigned short FAO_String_Size;
{
	auto   unsigned long *Ptr;
	auto   unsigned long Sys_Status;
	auto   int Index;
	static struct dsc$descriptor Msg_Desc, FAO_Desc, Arg_Desc[4];
	static unsigned long FAO_Arg_List[8];
	static unsigned short Length;
	static char *FAO_Msg = "%GETMSG-X-FAOERR, error from FAO system service";
	extern unsigned long Lib$CallG(), Lib$Sys_FAO();
/*
 *	Set up for the FAO call. If the argument type is 1 (string), build
 *	a descriptor:
 */
	Make_VMS_Descriptor (Msg_String, &Msg_Desc);
	Set_VMS_Descriptor (FAO_String, FAO_String_Size-1, &FAO_Desc);
	Ptr = &FAO_Arg_List[0];
	*Ptr++ = Arg_Count + 3;
	*Ptr++ = &Msg_Desc;
	*Ptr++ = &Length;
	*Ptr++ = &FAO_Desc;
	for (Index = 0; Index < Arg_Count; Index++)
	if (Arg_Type[Index] == 0)		/* Numeric, copy arg directly */
		*Ptr++ = Arg_Value[Index];
	else {					/* String, make descriptor */
		Make_VMS_Descriptor (Arg_Value[Index], &Arg_Desc[Index]);
		*Ptr++ = &Arg_Desc[Index];
	}
/*
 *	Call FAO service indirectly through CALLG service:
 */
	Sys_Status = Lib$CallG (FAO_Arg_List, &Lib$Sys_FAO);
	if ((Sys_Status & 0x01) != 0)
		FAO_String[Length] = '\0';
	else
		stringcpy_m (FAO_String, FAO_Msg, FAO_String_Size);
}
