#define EXTERN extern
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include "omegad.h"
#undef read

void
runexternalocp P1C(string, external_ocp_name)
{
  int outpipes[2], inpipes[2];
  char *outbuf;
  char *inbuf;
  int n;
  int chars_read_in, chars_to_go_out;
  int myerrno;

  /* Make pipes to send data from the parent to the child.  The parent
     writes to outpipes[0], and the child reads from outpipes[1].  */
  pipe (outpipes);
  /* Make pipes to send data from the child to the parent.  The child
     writes to inpipes[0], and the parent reads from inpipes[1].  */
  pipe (inpipes);

  /* For a child process.  */
  if (fork () == 0)
    {
      /* This part is executed by the child process.  It translates
         lower case letters to upper case.  */

      char *prog = external_ocp_name+1;
      char *args[] = {external_ocp_name+1, NULL};

      /* Close unnecessary pipes.  They are for the parent.  */
      close (outpipes[1]);
      close (inpipes[0]);

      /* Connect pipes to stdin and stdout.  */
      dup2 (outpipes[0], 0);
      dup2 (inpipes[1], 1);

      /* Overlays a new process image on an old process. */
      execv (prog, args);

      /* We should never reach here. */
    }
  else
    {
      /* Close unnecessary pipes.  They are for the child.  */
      close (outpipes[0]);
      close (inpipes[1]);

/* Here is the interesting part */
      outbuf = ((char *) otpinputbuf)+2;
      inbuf = ((char *) otpoutputbuf)+2;
      chars_to_go_out = 2*otpinputend;
      chars_read_in = 0;
      while ((n = write (outpipes[1], outbuf, chars_to_go_out))>0) {
fprintf(stderr, "Wrote (1) %d characters\n", n);
        outbuf+=n;
        chars_to_go_out-=n;
        if (chars_to_go_out==0) goto done_writing;
/*
        n = read (inpipes[0], inbuf, 1024);
fprintf(stderr, "Read (1) %d characters\n", n);
        inbuf+=n;
        chars_read_in+=n;
*/
      }
fprintf(stderr, "Wrote (2) %d characters\n", n);

done_writing:
      close (outpipes[1]);
      while ((n = read (inpipes[0], inbuf, 1024)) > 0) {
fprintf(stderr, "Read (2) %d characters\n", n);
        inbuf+=n;
        chars_read_in+=n;
      }
fprintf(stderr, "Read (3) %d characters\n", n);
      otpoutputend = chars_read_in / 2;

      close (inpipes[0]);
    }
}

