/* SIMPLE - Simple Is a Macro Processing Language Element */
/* Copyright (c) 1998 David A. Madore (david.madore@ens.fr) */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * This is the main program file.
 */

#include <stdio.h>
#if defined(HAVE_UNISTD_H)
#include <unistd.h>
#endif
#if defined(HAVE_GETOPT_H)
#include <getopt.h>
#endif
#include <stdlib.h>

#include "simple.h"

char char_escape_next = '`';
char char_escape_string = '"';
char char_comment = '%';
char char_begin_command = '<';
char char_end_command = '>';
char char_next_param = '|';
char char_open_quote = '[';
char char_close_quote = ']';
char char_quote_next = '#';
char char_at_sign = '@';

#if defined(HAVE_GETOPT_LONG)
static const struct option long_options[] = {
  {"help",no_argument,NULL,'h'},
  {"version",no_argument,NULL,'V'},
  {"copying",no_argument,NULL,'c'},
  {NULL,0,NULL,0}
};
#endif

#if (defined(HAVE_GETOPT) || defined(HAVE_GETOPT_LONG)) && !defined(HAVE_GETOPT_H)
  extern int optind;
#endif

int
main(int argc,char **argv)
{
#if defined(HAVE_GETOPT) || defined(HAVE_GETOPT_LONG)
  int opt;
#if defined(HAVE_GETOPT_LONG)
  while ((opt=getopt_long(argc,argv,"hVc",long_options,NULL))!=EOF)
#else
  while ((opt=getopt(argc,argv,"hVc"))!=EOF)
#endif
  {
    switch (opt) {
    case 'h':
      fprintf(stderr,"Usage is %s [OPTION]... [FILE]...\n",argv[0]);
#if !defined(HAVE_GETOPT_LONG)
      fprintf(stderr,"(Long options unavailable.)\n");
#endif
      fprintf(stderr,"\
Valid options are:\n\
  -h, --help                   display this help and exit\n\
  -V, --version                display version information and exit\n\
  -c, --copying                display copying information and exit\n\
");
      exit(EXIT_SUCCESS);
      break;
    case 'V':
      fprintf(stderr,PACKAGE " " VERSION "\n");
      fprintf(stderr,"Simple Is a Macro Processing Language Element\n");
      exit(EXIT_SUCCESS);
      break;
    case 'c':
      fprintf(stderr,"\
This program is free software; you can redistribute it and/or\n\
modify it under the terms of the GNU General Public License\n\
as published by the Free Software Foundation; either version\n\
2 of the License, or (at your option) any later version.\n\
\n\
This program is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY; without even the implied warranty\n\
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See\n\
the GNU General Public License for more details.\n\
\n\
You should have received a copy of the GNU General Public License\n\
along with this program; if not, write to the Free Software\n\
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n\
");
      exit(EXIT_SUCCESS);
      break;
    default:
      fprintf(stderr,"Type %s --help for a list of valid options.\n",argv[0]);
      exit(EXIT_FAILURE);
      break;
    }
  }
#else /* defined(HAVE_GETOPT) || defined(HAVE_GETOPT_LONG) */
  int optind;
  optind=1;
#endif /* defined(HAVE_GETOPT) || defined(HAVE_GETOPT_LONG) */
  init_syntax();
  if (argc==optind) {
    push_input_file("-");
  } else for (;optind<argc;argc--) {
    push_input_file(argv[argc-1]);
  }
  expand_input();
  return 0; /* This never gets executed, in fact. */
}
