/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class HtmlTag
extends AbstractTeXObject {
    private String tag;

    public HtmlTag(String string) {
        this.tag = string;
    }

    @Override
    public Object clone() {
        return new HtmlTag(this.getTag());
    }

    @Override
    public boolean isDataObject() {
        return true;
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) {
        return teXParser.getListener().createString(this.getTag());
    }

    public String toString() {
        return String.format("%s[tag=%s]", this.getClass().getSimpleName(), this.getTag());
    }

    @Override
    public String format() {
        return this.getTag();
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.getTag();
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.getListener().getWriteable().writeliteral(this.tag);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    public String getTag() {
        return this.tag;
    }

    public static String encodeAttributeValue(String string, boolean bl) {
        return HtmlTag.encodeAttributeValue(string, bl, false);
    }

    public static String encodeAttributeValue(String string, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < string.length()) {
            int n2 = string.codePointAt(n);
            n += Character.charCount(n2);
            if (n2 == 92 || n2 == 34 || n2 == 39 || n2 == 60 || n2 == 62) {
                if (bl) {
                    stringBuilder.append('%');
                } else {
                    stringBuilder.append("\\x");
                }
                stringBuilder.append(String.format("%X", n2));
                continue;
            }
            if (bl2 && n2 > 127) {
                stringBuilder.append(String.format("&#x%x;", n2));
                continue;
            }
            stringBuilder.appendCodePoint(n2);
        }
        return stringBuilder.toString();
    }

    public static String getUriFragment(String string) {
        try {
            URI uRI = new URI(null, null, string);
            return uRI.getRawFragment();
        }
        catch (URISyntaxException uRISyntaxException) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == ':' || c == '-' || c == '_') && c != '+') continue;
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
    }
}

