/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.latex3;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.latex3.L3StorageCommand;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;

public class PropertyCommand<T>
extends ControlSequence
implements L3StorageCommand {
    protected Hashtable<T, TeXObject> hashtable = new Hashtable();

    public PropertyCommand(String string) {
        super(string);
    }

    public PropertyCommand(String string, PropertyCommand<T> propertyCommand) {
        super(string);
        Enumeration<T> enumeration = this.hashtable.keys();
        while (enumeration.hasMoreElements()) {
            T t = enumeration.nextElement();
            this.hashtable.put(t, (TeXObject)propertyCommand.get(t).clone());
        }
    }

    @Override
    public Object clone() {
        return new PropertyCommand<T>(this.getName(), this);
    }

    public static <T> PropertyCommand<T> getPropertyCommand(String string, TeXParser teXParser, boolean bl) throws TeXSyntaxException {
        PropertyCommand<T> propertyCommand;
        ControlSequence controlSequence = teXParser.getControlSequence(string);
        if (controlSequence == null) {
            propertyCommand = new PropertyCommand<T>(string);
            if (bl) {
                teXParser.putControlSequence(string.startsWith("l_"), propertyCommand);
            }
        } else {
            propertyCommand = PropertyCommand.toPropertyCommand(controlSequence, teXParser, bl);
        }
        return propertyCommand;
    }

    public static <T> PropertyCommand<T> toPropertyCommand(TeXObject teXObject, TeXParser teXParser, boolean bl) throws TeXSyntaxException {
        PropertyCommand propertyCommand;
        ControlSequence controlSequence;
        Object object;
        if (teXObject instanceof TeXCsRef) {
            object = ((TeXCsRef)teXObject).getName();
            controlSequence = teXParser.getControlSequence((String)object);
            if (controlSequence == null) {
                PropertyCommand<T> propertyCommand2 = new PropertyCommand<T>((String)object);
                if (bl) {
                    teXParser.putControlSequence(((String)object).startsWith("l_"), propertyCommand2);
                }
                return propertyCommand2;
            }
        } else if (teXObject instanceof ControlSequence) {
            controlSequence = (ControlSequence)teXObject;
        } else if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) instanceof ControlSequence) {
            controlSequence = (ControlSequence)teXObject;
        } else {
            throw new LaTeXSyntaxException(teXParser, "latex.not.property", new Object[0]);
        }
        if (controlSequence instanceof Undefined) {
            object = controlSequence.getName();
            propertyCommand = new PropertyCommand((String)object);
            if (bl) {
                teXParser.putControlSequence(((String)object).startsWith("l_"), propertyCommand);
            }
        } else if (controlSequence instanceof PropertyCommand) {
            object = teXParser.getSettings();
            String string = controlSequence.getName();
            if (bl && string.startsWith("l_") && !((TeXSettings)object).isDefinedInCurrentScope(string)) {
                PropertyCommand propertyCommand3;
                propertyCommand = propertyCommand3 = (PropertyCommand)controlSequence.clone();
                ((TeXSettings)object).putControlSequence(propertyCommand);
            } else {
                PropertyCommand propertyCommand4;
                propertyCommand = propertyCommand4 = (PropertyCommand)controlSequence;
            }
        } else {
            throw new LaTeXSyntaxException(teXParser, "latex.not.property", new Object[0]);
        }
        return propertyCommand;
    }

    @Override
    public boolean isEmpty() {
        return this.hashtable.isEmpty();
    }

    public int size() {
        return this.hashtable.size();
    }

    @Override
    public void clear() {
        this.hashtable.clear();
    }

    @Override
    public void append(TeXObject teXObject) {
    }

    @Override
    public void prepend(TeXObject teXObject) {
    }

    public TeXObject get(T t) {
        return this.hashtable.get(t);
    }

    public TeXObject getOrDefault(T t, TeXObject teXObject) {
        return this.hashtable.getOrDefault(t, teXObject);
    }

    public void put(T t, TeXObject teXObject) {
        this.hashtable.put(t, teXObject);
    }

    public TeXObject remove(T t) {
        return this.hashtable.remove(t);
    }

    public boolean remove(T t, TeXObject teXObject) {
        return this.hashtable.remove(t, teXObject);
    }

    public Enumeration<T> keys() {
        return this.hashtable.keys();
    }

    public Set<T> keySet() {
        return this.hashtable.keySet();
    }

    public Enumeration<TeXObject> elements() {
        return this.hashtable.elements();
    }

    public Collection<TeXObject> values() {
        return this.hashtable.values();
    }

    public Hashtable<T, TeXObject> getHashtable() {
        return this.hashtable;
    }

    @Override
    public void setQuantity(TeXParser teXParser, TeXObject teXObject) throws TeXSyntaxException {
    }

    @Override
    public TeXObject getQuantity(TeXParser teXParser, TeXObjectList teXObjectList) throws TeXSyntaxException {
        return new TeXObjectList();
    }

    @Override
    public TeXObject getContent() {
        return new TeXObjectList();
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
    }
}

