/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.gui.TwoColumnConstraints;

public class TwoColumnConstraintsFactory {
    private static final String ALIGNMENT = "align";
    private static final String LABEL_ALIGNMENT = "label_align";
    private static final String CONTROL_ALIGNMENT = "control_align";
    private static final String LABEL_POSITION = "label_position";
    private static final String CONTROL_POSITION = "control_position";
    private static final String LABEL_INDENT = "label_indent";
    private static final String CONTROL_INDENT = "control_indent";
    private static final String LEFT = "left";
    private static final String CENTER = "center";
    private static final String RIGHT = "right";
    private static final String WEST = "west";
    private static final String WESTONLY = "westonly";
    private static final String EAST = "east";
    private static final String EASTONLY = "eastonly";
    private static final String BOTH = "both";
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public static TwoColumnConstraints createTextConstraint(IXMLElement field) {
        return TwoColumnConstraintsFactory.createTextConstraint(field, 29, false, false);
    }

    public static TwoColumnConstraints createLabelConstraint(IXMLElement field) {
        return TwoColumnConstraintsFactory.createLabelConstraint(field, 15, false, false);
    }

    public static TwoColumnConstraints createControlConstraint(IXMLElement field) {
        return TwoColumnConstraintsFactory.createControlConstraint(field, 26, false, false);
    }

    public static TwoColumnConstraints createTextConstraint(IXMLElement field, int position, boolean indent, boolean stretch) {
        TwoColumnConstraints constraint = new TwoColumnConstraints();
        constraint.position = position;
        constraint.indent = indent;
        constraint.stretch = stretch;
        constraint.align = 31;
        TwoColumnConstraintsFactory.overrideTextDefaults(constraint, field);
        return constraint;
    }

    public static TwoColumnConstraints createControlConstraint(IXMLElement field, int position, boolean indent, boolean stretch) {
        TwoColumnConstraints constraint = new TwoColumnConstraints();
        constraint.position = position;
        constraint.indent = indent;
        constraint.stretch = stretch;
        constraint.align = 31;
        TwoColumnConstraintsFactory.overrideControlDefaults(constraint, field);
        return constraint;
    }

    public static TwoColumnConstraints createLabelConstraint(IXMLElement field, int position, boolean indent, boolean stretch) {
        TwoColumnConstraints constraint = new TwoColumnConstraints();
        constraint.position = position;
        constraint.indent = indent;
        constraint.stretch = stretch;
        constraint.align = 31;
        TwoColumnConstraintsFactory.overrideLabelDefaults(constraint, field);
        return constraint;
    }

    private static void overrideTextDefaults(TwoColumnConstraints constraint, IXMLElement field) {
        if (field != null) {
            TwoColumnConstraintsFactory.overrideAlignment(constraint, field.getAttribute(ALIGNMENT));
            TwoColumnConstraintsFactory.overrideAlignment(constraint, field.getAttribute(LABEL_ALIGNMENT));
        }
    }

    private static void overrideLabelDefaults(TwoColumnConstraints constraint, IXMLElement field) {
        if (field != null) {
            TwoColumnConstraintsFactory.overrideAlignment(constraint, field.getAttribute(LABEL_ALIGNMENT));
            TwoColumnConstraintsFactory.overridePosition(constraint, field.getAttribute(LABEL_POSITION));
            TwoColumnConstraintsFactory.overrideIndent(constraint, field.getAttribute(LABEL_INDENT));
        }
    }

    private static void overrideControlDefaults(TwoColumnConstraints constraint, IXMLElement field) {
        if (field != null) {
            TwoColumnConstraintsFactory.overrideAlignment(constraint, field.getAttribute(CONTROL_ALIGNMENT));
            TwoColumnConstraintsFactory.overridePosition(constraint, field.getAttribute(CONTROL_POSITION));
            TwoColumnConstraintsFactory.overrideIndent(constraint, field.getAttribute(CONTROL_INDENT));
        }
    }

    private static void overrideAlignment(TwoColumnConstraints constraint, String value) {
        if (value != null) {
            if (value.equalsIgnoreCase(LEFT)) {
                constraint.align = 31;
            } else if (value.equalsIgnoreCase(CENTER)) {
                constraint.align = 35;
            } else if (value.equalsIgnoreCase(RIGHT)) {
                constraint.align = 47;
            }
        }
    }

    private static void overridePosition(TwoColumnConstraints constraint, String value) {
        if (value != null) {
            if (value.equalsIgnoreCase(WEST)) {
                constraint.position = 15;
            } else if (value.equalsIgnoreCase(EAST)) {
                constraint.position = 26;
            } else if (value.equalsIgnoreCase(BOTH)) {
                constraint.position = 29;
            } else if (value.equalsIgnoreCase(WESTONLY)) {
                constraint.position = 16;
            } else if (value.equalsIgnoreCase(EASTONLY)) {
                constraint.position = 27;
            }
        }
    }

    private static void overrideIndent(TwoColumnConstraints constraint, String value) {
        if (value != null) {
            if (value.equalsIgnoreCase(TRUE)) {
                constraint.indent = true;
            } else if (value.equalsIgnoreCase(FALSE)) {
                constraint.indent = false;
            }
        }
    }
}

