/* l2xicmon.h   for LTX2X interpreter */
/* BASED ON: common.h   (unaltered)  */

#ifndef common_h
#define common_h

#define FORM_FEED_CHAR '\f'
#define MAX_FILE_NAME_LENGTH 32
#define MAX_SOURCE_LINE_LENGTH 256
#define MAX_PRINT_LINE_LENGTH 80
#define MAX_LINES_PER_PAGE 50
#define DATE_STRING_LENGTH 26
#define MAX_TOKEN_STRING_LENGTH MAX_SOURCE_LINE_LENGTH
#define MAX_CODE_BUFFER_SIZE 4096
#define MAX_NESTING_LEVEL 16
#define MAX_STACK_SIZE 1024
#define STACK_FRAME_HEADER_SIZE 4
#define MAX_EXPRESS_STRING 2048
#define MAX_AGG_SIZE 1024

/* typedef enum { FALSE, TRUE, } BOOLEAN; */
typedef int BOOLEAN; 
#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif


/* PRW change ADDRESS */
/* typedef char *ADDRESS; */
#ifndef L2XCOM_H
typedef int ICT;          /* intermediate code segment type */
#endif
typedef ICT *ADDRESS;     /* ptr into code segment */

/* macros for memory allocation */
#define alloc_struct(type)       (type *) malloc(sizeof(type))
#define alloc_array(type, count) (type *) malloc(count*sizeof(type))
#define alloc_bytes(length)      (char *) malloc(length)

  /* PW additions */
#define EOS '\0'

extern FILE *ferr;               /* error o/p file */
extern FILE *fcodeseg;           /* code segment o/p file */
extern FILE *filout;             /* result output file */

extern int SLD_OFF;              /* TRUE if source level debugger disabled */

  /* for numbers */
typedef long int XPRSAINT;   /* C type for INTEGER */
typedef double XPRSAREAL;    /* C type for REAL */

#define MAX_INTEGER     2147483647
#define MAX_DIGIT_COUNT 20
#define MAX_EXPONENT    37

#endif
