/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor.partitioner;

import net.sourceforge.texlipse.editor.partitioner.BufferedDocumentScanner;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class FastLaTeXPartitionScanner
implements IPartitionTokenScanner {
    public static final String TEX_DEFAULT = "__tex_default";
    public static final String TEX_COMMENT = "__tex_commentPartition";
    public static final String TEX_MATH = "__tex_mathPartition";
    public static final String TEX_CURLY_BRACKETS = "__tex_curlyBracketPartition";
    public static final String TEX_SQUARE_BRACKETS = "__tex_squareBracketPartition";
    public static final String TEX_VERBATIM = "__tex_VerbatimPartition";
    public static final String[] TEX_PARTITION_TYPES = new String[]{"__dftl_partition_content_type", "__tex_commentPartition", "__tex_mathPartition", "__tex_curlyBracketPartition", "__tex_squareBracketPartition", "__tex_VerbatimPartition"};
    private static final int TEX = 0;
    private static final int COMMENT = 1;
    private static final int MATH = 2;
    private static final int VERBATIM = 3;
    private static final int ARGS = 4;
    private static final int OPT_ARGS = 5;
    private static final String BEGIN = "begin";
    private static final String END = "end";
    private static final String VERB = "verb";
    private static final String LSTINLINE = "lstinline";
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
    private final IToken[] fTokens = new IToken[]{new Token(null), new Token((Object)"__tex_commentPartition"), new Token((Object)"__tex_mathPartition"), new Token((Object)"__tex_VerbatimPartition"), new Token((Object)"__tex_curlyBracketPartition"), new Token((Object)"__tex_squareBracketPartition")};
    private int fTokenOffset;
    private int fTokenLength;
    private String currContentType;

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        if (!"__dftl_partition_content_type".equals(contentType) && partitionOffset != -1 && partitionOffset < offset) {
            this.fScanner.setRange(document, partitionOffset, length + (offset - partitionOffset));
            this.fTokenOffset = partitionOffset;
            this.fTokenLength = 0;
            this.currContentType = null;
        } else {
            this.fScanner.setRange(document, offset, length);
            this.fTokenOffset = offset;
            this.fTokenLength = 0;
            this.currContentType = contentType;
        }
    }

    public void setRange(IDocument document, int offset, int length) {
        this.currContentType = null;
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fTokenLength = 0;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public IToken nextToken() {
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = 0;
        int ch = this.fScanner.read();
        if (ch == -1) {
            ++this.fTokenLength;
            return Token.EOF;
        }
        switch (ch) {
            case 92: {
                int c1 = this.fScanner.read();
                if (c1 != 98 && c1 != 91 && c1 != 40 && c1 != 118 && c1 != 108) {
                    this.fTokenLength += 2;
                    return this.fTokens[0];
                }
                if (c1 == 40 || c1 == 91) {
                    int offsetEnd = this.fTokenOffset;
                    ch = this.fScanner.read();
                    offsetEnd += 2;
                    while (true) {
                        ch = this.fScanner.read();
                        ++offsetEnd;
                        if (ch == 92) {
                            int ch2 = this.fScanner.read();
                            ++offsetEnd;
                            if ((ch2 != 93 || c1 != 91) && (ch2 != 41 || c1 != 40)) continue;
                            this.fTokenLength = ++offsetEnd - this.fTokenOffset;
                            return this.fTokens[2];
                        }
                        if (ch == 37) {
                            offsetEnd += this.ignoreComment();
                            continue;
                        }
                        if (ch == 36) {
                            this.fScanner.unread();
                            this.fTokenLength = offsetEnd - this.fTokenOffset;
                            return this.fTokens[2];
                        }
                        if (ch == -1) break;
                    }
                    this.fTokenLength = offsetEnd - this.fTokenOffset - 1;
                    return this.fTokens[2];
                }
                if (c1 == 98) {
                    return this.checkForEnv();
                }
                if (c1 == 118 || c1 == 108) {
                    return this.checkForVerb();
                }
                this.fTokenLength += 2;
                return this.fTokens[0];
            }
            case 36: {
                int offsetEnd = this.fTokenOffset;
                int c1 = this.fScanner.read();
                offsetEnd += 2;
                while (true) {
                    ch = this.fScanner.read();
                    ++offsetEnd;
                    if (ch == 92) {
                        ch = this.fScanner.read();
                        ++offsetEnd;
                        if (ch != 91 && ch != 93 && ch != 40 && ch != 41) continue;
                        this.fScanner.unread();
                        this.fScanner.unread();
                        this.fTokenLength = (offsetEnd -= 2) - this.fTokenOffset;
                        return this.fTokens[2];
                    }
                    if (ch == 37) {
                        offsetEnd += this.ignoreComment();
                        continue;
                    }
                    if (ch == 36 && c1 != 36) {
                        this.fTokenLength = offsetEnd - this.fTokenOffset;
                        return this.fTokens[2];
                    }
                    if (ch == 36) {
                        c1 = 32;
                        continue;
                    }
                    if (ch == -1) break;
                }
                this.fTokenLength = offsetEnd - this.fTokenOffset - 1;
                return this.fTokens[2];
            }
            case 37: {
                int offsetEnd = this.fTokenOffset;
                ++offsetEnd;
                do {
                    ch = this.fScanner.read();
                    ++offsetEnd;
                    if (ch != 13 && ch != 10) continue;
                    this.fScanner.unread();
                    this.fTokenLength = --offsetEnd - this.fTokenOffset;
                    return this.fTokens[1];
                } while (ch != -1);
                this.fTokenLength = offsetEnd - this.fTokenOffset - 1;
                return this.fTokens[1];
            }
            case 123: {
                return this.scanBracket(123, 125, 4, this.fTokenOffset + 1);
            }
            case 91: {
                return this.scanBracket(91, 93, 5, this.fTokenOffset + 1);
            }
        }
        int offsetEnd = this.fTokenOffset + 1;
        while (ch != 36 && ch != 92 && ch != 37 && ch != 123 && ch != 91 && ch != -1) {
            ch = this.fScanner.read();
            ++offsetEnd;
        }
        if (ch != -1) {
            this.fScanner.unread();
        }
        this.fTokenLength = --offsetEnd - this.fTokenOffset;
        return this.fTokens[0];
    }

    private int ignoreComment() {
        int ch = this.fScanner.read();
        int r = 1;
        while (ch != 13 && ch != 10 && ch != -1) {
            ch = this.fScanner.read();
            ++r;
        }
        return r;
    }

    private int checkForCommand(String command, int start) {
        int i = start;
        while (i < command.length()) {
            int ch = this.fScanner.read();
            if (command.charAt(i) != ch) {
                this.unReadScanner(i - start + 1);
                return 0;
            }
            ++i;
        }
        return command.length() - start;
    }

    private IToken checkForVerb() {
        int o = this.checkForCommand(VERB, 1);
        if (o == 0 && (o = this.checkForCommand(LSTINLINE, 1)) == 0) {
            this.fTokenLength += 2;
            return this.fTokens[0];
        }
        int offsetEnd = this.fTokenOffset;
        offsetEnd += o + 2;
        int verbch = this.fScanner.read();
        ++offsetEnd;
        if (Character.isLetter(verbch)) {
            this.fTokenLength = offsetEnd - this.fTokenOffset;
            return this.fTokens[0];
        }
        int ch = this.fScanner.read();
        ++offsetEnd;
        while (ch != verbch && ch != -1 && ch != 13 && ch != 10) {
            ch = this.fScanner.read();
            ++offsetEnd;
        }
        if (ch != verbch) {
            --offsetEnd;
        }
        this.fTokenLength = offsetEnd - this.fTokenOffset;
        return this.fTokens[3];
    }

    private IToken checkForEnv() {
        int o = this.checkForCommand(BEGIN, 1);
        if (o == 0) {
            this.fTokenLength += 2;
            return this.fTokens[0];
        }
        int offsetEnd = this.fTokenOffset;
        offsetEnd += 6;
        int ch = this.fScanner.read();
        ++offsetEnd;
        while (Character.isWhitespace(ch)) {
            ch = this.fScanner.read();
            ++offsetEnd;
        }
        if (ch != 123) {
            this.unReadScanner(offsetEnd - this.fTokenOffset - 2);
            this.fTokenLength += 2;
            return this.fTokens[0];
        }
        StringBuilder b = new StringBuilder();
        ch = this.fScanner.read();
        ++offsetEnd;
        while (ch != 125 && ch != -1 && ch != 123 && ch != 92) {
            b.append((char)ch);
            ch = this.fScanner.read();
            ++offsetEnd;
        }
        String envName = b.toString();
        if (FastLaTeXPartitionScanner.isMathEnv(envName) || this.isVerbatimEnv(envName) || this.isCommentEnv(envName)) {
            return this.checkForEndEnv(envName, offsetEnd);
        }
        this.unReadScanner(offsetEnd - this.fTokenOffset - 2);
        this.fTokenLength += 2;
        return this.fTokens[0];
    }

    private IToken checkForEndEnv(String name, int offsetEnd) {
        while (true) {
            int ch = this.fScanner.read();
            ++offsetEnd;
            if (ch == 37) {
                offsetEnd += this.ignoreComment();
                ch = this.fScanner.read();
                ++offsetEnd;
            }
            if (ch == 92) {
                boolean isEnv = true;
                int i = 0;
                while (i < END.length()) {
                    ch = this.fScanner.read();
                    ++offsetEnd;
                    if (END.charAt(i) != ch) {
                        isEnv = false;
                        break;
                    }
                    ++i;
                }
                if (!isEnv) continue;
                ch = this.fScanner.read();
                ++offsetEnd;
                while (Character.isWhitespace(ch)) {
                    ch = this.fScanner.read();
                    ++offsetEnd;
                }
                if (ch != 123) continue;
                StringBuilder b = new StringBuilder();
                ch = this.fScanner.read();
                ++offsetEnd;
                while (ch != 125 && ch != -1 && ch != 123 && ch != 92) {
                    b.append((char)ch);
                    ch = this.fScanner.read();
                    ++offsetEnd;
                }
                String envName = b.toString();
                if (!envName.equals(name)) continue;
                this.fTokenLength = offsetEnd - this.fTokenOffset;
                if (FastLaTeXPartitionScanner.isMathEnv(envName)) {
                    return this.fTokens[2];
                }
                if (this.isVerbatimEnv(envName)) {
                    return this.fTokens[3];
                }
                if (!this.isCommentEnv(envName)) continue;
                return this.fTokens[1];
            }
            if (ch != -1) continue;
            this.fTokenLength = offsetEnd - this.fTokenOffset - 1;
            if (FastLaTeXPartitionScanner.isMathEnv(name)) {
                return this.fTokens[2];
            }
            if (this.isVerbatimEnv(name)) {
                return this.fTokens[3];
            }
            if (this.isCommentEnv(name)) break;
        }
        return this.fTokens[1];
    }

    private IToken scanBracket(int openChar, int closeChar, int type, int currentOffset) {
        int offsetEnd = currentOffset;
        int stack = 0;
        while (true) {
            int ch = this.fScanner.read();
            ++offsetEnd;
            if (ch == closeChar) {
                if (--stack >= 0) continue;
                this.fTokenLength = offsetEnd - this.fTokenOffset;
                return this.fTokens[type];
            }
            if (ch == openChar) {
                ++stack;
                continue;
            }
            if (ch == 37) {
                offsetEnd += this.ignoreComment();
                continue;
            }
            if (ch == 92) {
                ch = this.fScanner.read();
                ++offsetEnd;
                continue;
            }
            if (ch == -1) break;
        }
        this.fTokenLength = offsetEnd - this.fTokenOffset - 1;
        return this.fTokens[type];
    }

    private boolean unReadScanner(int readChar) {
        int j = 0;
        while (j < readChar) {
            this.fScanner.unread();
            ++j;
        }
        return false;
    }

    public static final boolean isMathEnv(String envName) {
        String st;
        String[] MATHRULESSTAR = new String[]{"equation", "eqnarray", "align", "alignat", "flalign", "multline", "gather"};
        String[] MATHRULESNOSTAR = new String[]{"math", "displaymath"};
        String[] stringArray = MATHRULESSTAR;
        int n = MATHRULESSTAR.length;
        int n2 = 0;
        while (n2 < n) {
            st = stringArray[n2];
            if (st.equals(envName) || (String.valueOf(st) + '*').equals(envName)) {
                return true;
            }
            ++n2;
        }
        stringArray = MATHRULESNOSTAR;
        n = MATHRULESNOSTAR.length;
        n2 = 0;
        while (n2 < n) {
            st = stringArray[n2];
            if (st.equals(envName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isVerbatimEnv(String envName) {
        String[] VERBATIMRULE;
        String[] stringArray = VERBATIMRULE = new String[]{"verbatim", "Verbatim", "lstlisting"};
        int n = VERBATIMRULE.length;
        int n2 = 0;
        while (n2 < n) {
            String st = stringArray[n2];
            if (st.equals(envName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isCommentEnv(String envName) {
        String[] COMMENTRULE;
        String[] stringArray = COMMENTRULE = new String[]{"comment"};
        int n = COMMENTRULE.length;
        int n2 = 0;
        while (n2 < n) {
            String st = stringArray[n2];
            if (st.equals(envName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

