/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.templates;

import java.util.Collections;
import java.util.List;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.templates.BibTexContextType;
import net.sourceforge.texlipse.templates.CompletionProposalComparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;

public class BibTexTemplateCompletion
extends TemplateCompletionProcessor {
    protected Template[] getTemplates(String contextTypeId) {
        return TexlipsePlugin.getDefault().getBibTemplateStore().getTemplates();
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return TexlipsePlugin.getDefault().getBibContextTypeRegistry().getContextType(BibTexContextType.BIBTEX_CONTEXT_TYPE);
    }

    protected Image getImage(Template template) {
        return TexlipsePlugin.getImage("template");
    }

    public void addTemplateProposals(ITextViewer viewer, int documentOffset, List propList) {
        ICompletionProposal[] templateProposals = this.computeCompletionProposals(viewer, documentOffset);
        int j = 0;
        while (j < templateProposals.length) {
            propList.add(templateProposals[j]);
            ++j;
        }
        Collections.sort(propList, new CompletionProposalComparator());
    }

    protected String extractPrefix(ITextViewer viewer, int offset) {
        int i = offset - 1;
        if (i == -1) {
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        try {
            char c = viewer.getDocument().getChar(i);
            while (!Character.isWhitespace(c)) {
                sb.append(c);
                if (--i >= 0) {
                    c = viewer.getDocument().getChar(i);
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("BibTemplateCompletion, extractPrefix.", e);
        }
        return sb.reverse().toString();
    }
}

