# TeX run with the file $main_file$tsuff and with the format $texmem$texfmt
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen
# Copyright (C) 1996  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc tex {f austext} {# TeX run: file $main_file$tsuff, format $texfmt   

  upvar 1 $austext a

  global  texfmt main_file tsuff prsuffix texmem texrun texmax texlogopts
  global  editor edsubback env vv xtermcall xtem_path tclcall texonemorerun texedit

  set noedittext "\n$vv(ten1)\n$vv(ten2)\n"
  eval set noeditortext \"\n$vv(ten3)\n$vv(ten4) $vv(ten2)\n\$vv(tsrt2)\n\"


  if {($texonemorerun==0)&&($texrun==1)} {writescr0 $f ""}
  writescr $f  "[datime] $vv(te1) $texfmt $main_file$tsuff\n"
  if {($texrun>1)&&($texonemorerun==0)} {# 2th, 3rd, ... run (if max. number of TeX runs >1)
    writescr $f	"\n$texrun. $vv(te2)  $texmax  $vv(te3)\n\n"
    mybell 1
  }
  set a ""


  unlink -nocomplain .tmp.noedit

  if { $edsubback == 0 } {

    set Sig "signal unblock SIGCHLD"

    # you can either set variable texedit in file "locals_*/install.vst"
    # (e.g.  texedit nedit +%d %s
    #  or    texedit $tclcall -c \"$Sig\; exec $xtermcall -e ue +%d %s\"
    #  note that you have to protect semicolon and double-quotes)
    # or you can add a new "elseif" to the following list
    #
    # if you add an editor to the following list, please e-mail:  weibezahn@iwd.uni-bremen.de
    #
    if {$texedit!=""}			{eval set ev \"$texedit\"
    } elseif {$editor=="emacs"}		{set ev "emacs +%d %s"
    } elseif {$editor=="xemacs"}	{set ev "xemacs +%d %s"
    } elseif {$editor=="nedit"}		{set ev "nedit +%d %s"
    } elseif {$editor=="textedit"}	{set ev "textedit %s"
    } elseif {$editor=="ue"}	{set ev "$tclcall -c \"$Sig; exec $xtermcall -e ue +%d %s\""
    } elseif {$editor=="vi"}	{set ev "$tclcall -c \"$Sig; exec $xtermcall -e vi +%d %s\""
    } else			{set ev "echo \"$noeditortext\";touch .tmp.noedit"}
    set env(TEXEDIT) "$ev"

  } else {# editor in background: e-option forbidden, except with emacsserver/emacsclient 
    set env(TEXEDIT) "echo \"$noedittext\";touch .tmp.noedit"
  }


#   call of tex/latex/...

    ## either:
    ################################################################
    mkCmd_wait  $f  $texmem$texfmt  [list "$texlogopts $main_file$tsuff"]
    ################################################################
    ## or:
    ################################################################
    #set message ""
    #unlink -nocomplain "${main_file}.log"
    #regsub -all {\\} $texlogopts {\\\\} s
    #eval set r [catch "exec xterm -e $texmem$texfmt $s $main_file$tsuff " m];# no SigChld...!
    #set pid "$m"
    #if [file exists ${main_file}.log] {catFile ${main_file}.log $f}
    #if [file exists .tmp.noedit] {set a "${a}$noedittext"} 
    ################################################################

}


proc tex_post {f austext} {# after TeX run: .dvi -> .ps if postscript-preview

  upvar 1 $austext a

  global vv Wq env anl0 main_file mainfile tsuff hyphenprog hyphenopts hyphenchk hyphenchke
  global texpostbib texposthyph texpostind texpostps texposttex texonemorerun texloganalyze
  global tlFileCheck language tlaOutLstAct chksum_idx prsuffix prpreopt dirprefix

  if {$dirprefix==""} {set mainfile $main_file} else {set mainfile [fileName $main_file]}
  eval set hyphenchke \"$hyphenchk\"

  set a ""; set message ""; set dummy ""; set texonemorerun 0

  set dviNewGenerated [mdtest $main_file $tsuff .dvi dummy] 

  if {($texpostind==1)&&[winfo exists .c.2.in]} {

   set indexrunreq 0
   if {[file exists $main_file.idx]&&![file exists $main_file.ind]} {set indexrunreq 1}
   if {[file exists $main_file.idx]&&($chksum_idx!=[checksum .idx])} {set indexrunreq 1}

   if {$indexrunreq==1} {
     writescr $f "\n\n[datime] $vv(xtc2in) $vv(tea3)\n\n"
     index $f austxt; writescr $f "$austxt"
     set texonemorerun 1
   }
   mybell 1
  }

  if {$texpostbib==1} {

   set t "LaTeX Warning: There were undefined references"
   set mf "$main_file.log"
   SigChldB; set r [catch "exec grep \"$t\" $mf" m]; SigChldU

   TestPut 4 "<$t>  <$r> <$m> "
   if {$r==0} {set bibrun 1} else {set bibrun 0}

   if {$bibrun} {
     writescr $f "\n\n[datime] $vv(bib1) $main_file$tsuff $vv(tea3)\n"
     bibliogr $f austxt; writescr $f "$austxt"
     set texonemorerun 1
   }
   mybell 1
  }

  if {($texposttex==1)&&($texonemorerun==1)} {
    writescr .d.tt "\n\n"
    tex .d.tt austxt; if {$austxt!=""} {writescr .d.tt "\n$austxt"}
  }

  if {($texpostps==1)&&("$prsuffix"==".ps")&& \
      [file exists $main_file.dvi]&&($dviNewGenerated==1)} {
    # Postscript preview and .dvi-file newer than .tex-file, thus .dvi --> .ps
    writescr  $f "\n\n[datime] dvips $vv(tea3) $vv(tea4)\n"

    ## either:
    #SigChldB; catch "exec dvips $main_file.dvi $prpreopt -o $main_file.ps" message; SigChldU
    ## or:
    mkCmd_wait $f dvips "$main_file.dvi $prpreopt -o $main_file.ps"

  }


  if {($texloganalyze=="yes")&&[file exists $main_file.log]} {
    writescr .d.tt "\n$vv(xt36) ...\n"; update
    set tlFileCheck 1;  tlDriver .d.tt austxt;  writescr .d.tt "\n$austxt"
  }


  if {($texposthyph==1)&&[file exists $mainfile.dvi]&&([catch "which $hyphenprog" m]==0)} {

    if {[file exists $main_file$tsuff]} {set feType [fontenc]; set prType [hyphopt]}
    unlink -nocomplain $mainfile.hyp
    if {($hyphenchke!="")&&![file exists $hyphenchke]} \
		{SigChldB; exec touch $hyphenchke; SigChldU}
    writescr $f "\n[datime] $vv(teh0)\n$hyphenprog $hyphenopts $mainfile $hyphenchke"

    ## either:
    ################################################################
    eval mkCmd_wait $f $hyphenprog \[list $hyphenopts $mainfile $hyphenchke\]
    #eval mkCmd_wait $f $hyphenprog [list "$hyphenopts $mainfile $hyphenchke"]
    ################################################################
    ## or:
    ################################################################
    #SigChldB;set r [catch "exec $hyphenprog $hyphenopts $mainfile $hyphenchke" m];SigChldU
    #writescr $f "\n$m\n"
    ################################################################

    if {[file exists $main_file$tsuff]&& \
	  [file exists $mainfile.hyp]&&([file size $mainfile.hyp]>0)} {#check type compatibil.
	TestPut 4 "<<$feType>> <<$prType>>"
	if {($feType!="")&&($feType!=$prType)} \
	  {mybell 3; writescr $f "\n$vv(teh4) ($feType)\n$vv(teh5) ($prType)\n$vv(teh6)\n"}
	if {($feType=="")} \
	  {mybell 1; writescr $f "\n$vv(teh7)\n$vv(teh8) `$prType',\n$vv(teh9)\n"}
    }
    set tlaOutLstAct 1
    if {($hyphenchke!="")&&[file exists $mainfile.hyp]&&([file size $mainfile.hyp]>0)} {
	writescr $f "$vv(teh10) `$hyphenchke' $vv(teh11)!\n"
	button $f.ins -text " $vv(teh12) " -command "teHyphIns $f"
	$f window create insert -window $f.ins
	Bind3HF $f.ins te_hyph .d.tt
    }
    DelFileIfEmpty $hyphenchke; DelFileIfEmpty $mainfile.hyp
    mybell 1
  } elseif {($texposthyph==1)&&[file exists $mainfile.dvi]} {# program hyphen_show not found
    writescr $f "\n$vv(aprog) \"$hyphenprog\" $vv(teh3) $vv(anf)\n"; mybell 3
  }

  writescr  $f "$message\n[datime] $vv(tea5)\n"
  mybell 1

}

proc teHyphIns {w} {global vv Wq mainfile hyphenchke
  SigChldB; exec cat $mainfile.hyp >>$hyphenchke; SigChldU
  unlink -nocomplain $mainfile.hyp
  $w.ins configure -state disabled -text " $vv(teh13) "
}
proc fontenc {} {# returns font-encoding type (if found in .tex-file) or empty string
  global main_file tsuff
  SigChldB; set res [catch "exec grep \"\\usepackage\" $main_file$tsuff" erg]; SigChldU; lock
  if {$res==1} {return ""}
  set ergl [split "$erg" "\n"]
  set type ""
  foreach l "$ergl" {
    set l [lindex [split $l "%"] 0]
    if {[regexp {.*\\usepackage.*\[.*T1.*\].*\{.*fontenc.*\}} $l]} {set type T1}
    if {[regexp {.*\\usepackage.*\[.*OT1.*\].*\{.*fontenc.*\}} $l]} {set type OT1}
    TestPut 4 "<$l><$type>"
  }
  return $type
}
proc hyphopt {} {# returns font-encoding type (if not found in option string: default)
  global hyphenopts
  set type "T1"
  for {set i 0} {$i<[llength $hyphenopts]} {incr i} {
    if {[lindex $hyphenopts $i]=="-c"} {set type [lindex $hyphenopts [expr $i+1]]}
  }
  return $type
}
