## -*-Tcl-*-
 # ###################################################################
 #  AlphaVOODOO - integrates Alpha with VOODOO
 # 
 #  FILE: "voodooCoercions.tcl"
 #                                    created: 6/27/97 {10:48:05 pm} 
 #                                last update: 4/25/98 {1:54:17 PM} 
 #                                    version: 1.0.0b7
 #  Author: Jonathan Guyer
 #  E-mail: <jguyer@his.com>
 #     www: <http://www.his.com/~jguyer/>
 #  
 # 
 #  Copyright (C) 1997, 1998  Jonathan Guyer
 #  
 #  This program is free software; you can redistribute it and/or modify
 #  it under the terms of the GNU General Public License as published by
 #  the Free Software Foundation; either version 2 of the License, or
 #  (at your option) any later version.
 #  
 #  This program is distributed in the hope that it will be useful,
 #  but WITHOUT ANY WARRANTY; without even the implied warranty of
 #  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 #  GNU General Public License for more details.
 #  
 #  You should have received a copy of the GNU General Public License
 #  along with this program; if not, write to the Free Software
 #  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 # ###################################################################
 ##

namespace eval voodoo {}

#    kLSt - locking status codes 

proc voodoo::coerce::type:eNIP {blah} {
	return "not in project"
} 

proc voodoo::coerce::type:eUnl {blah} {
	return "unlocked"
} 

proc voodoo::coerce::type:eLSe {blah} {
	return "reserved"
} 

proc voodoo::coerce::type:eLOt {blah} {
	return "locked by another user"
} 

#    kRCA - add result codes 

proc voodoo::coerce::type:eOK {blah} {
	return "OK"
} 

proc voodoo::coerce::type:eFnf {blah} {
	return "file not found"
} 

proc voodoo::coerce::type:eInP {blah} {
	return "already in project"
} 

#    kRCL - store or fetch result codes 

#  (contrary to VOODOO's aete resource, these codes are not actually 
#  returned)

# 'eOK ', 'eNIP', and 'eLOt' already defined

proc voodoo::coerce::type:eNoR {blah} {
	return "no rights"
} 

#    kRCC - comparison result codes 

proc voodoo::coerce::type:eEqu {blah} {
	return "equal"
} 

proc voodoo::coerce::type:eDif {blah} {
	return "different"
} 

proc voodoo::coerce::type:eNa {blah} {
	return "n.a."
} 
