#define STRICT
#define NOUSER
#define NOKERNEL
#include <windows.h>
#include <sys/rsxw32.h>

/* -------- GDI SECTION -------------------------------------- */

BOOL LineTo(HDC hdc, short x, short y)
{
    STACKWORDS(1+1+1);

    PUSH_WORD(hdc);
    PUSH_WORD(x);
    PUSH_WORD(y);
    return WINCALL( 19,GDI);
}

DWORD MoveTo(HDC hdc, short x, short y)
{
    STACKWORDS(1+1+1);

    PUSH_WORD(hdc);
    PUSH_WORD(x);
    PUSH_WORD(y);
    return WINCALL( 20,GDI);
}

BOOL Ellipse(HDC hdc, short x1, short y1, short x2, short y2)
{
    STACKWORDS(1+1+1+1+1);

    PUSH_WORD(hdc);
    PUSH_WORD(x1);
    PUSH_WORD(y1);
    PUSH_WORD(x2);
    PUSH_WORD(y2);
    return WINCALL(24,GDI);
}

BOOL Rectangle(HDC hdc, short x1, short y1, short x2, short y2)
{
    STACKWORDS(1+1+1+1+1);

    PUSH_WORD(hdc);
    PUSH_WORD(x1);
    PUSH_WORD(y1);
    PUSH_WORD(x2);
    PUSH_WORD(y2);
    return WINCALL( 27,GDI);
}

BOOL PatBlt(HDC hdc, short x1, short y1, short x2, short y2, DWORD att)
{
    STACKWORDS(1+1+1+1+1+2);

    PUSH_WORD(hdc);
    PUSH_WORD(x1);
    PUSH_WORD(y1);
    PUSH_WORD(x2);
    PUSH_WORD(y2);
    PUSH_LONG(att);
    return WINCALL( 29,GDI);
}

BOOL TextOut(HDC hDC, short x, short y, LPCSTR text, short len)
{
    STACKWORDS(1+1+1+2+1);

    PUSH_WORD(hDC);
    PUSH_WORD(x);
    PUSH_WORD(y);
    PUSH_LPSTR(text);
    PUSH_WORD(len);
    return WINCALL(33,GDI);
}

BOOL BitBlt(HDC hdc1, short x1, short y1, short x2, short y2, HDC hdc2, short x, short y, DWORD att)
{
    STACKWORDS(1+1+1+1+1+1+1+1+2);

    PUSH_WORD(hdc1);
    PUSH_WORD(x1);
    PUSH_WORD(y1);
    PUSH_WORD(x2);
    PUSH_WORD(y2);
    PUSH_WORD(hdc2);
    PUSH_WORD(x);
    PUSH_WORD(y);
    PUSH_LONG(att);
    return WINCALL( 34,GDI);
}

BOOL Polyline (HDC hDC, const POINT FAR *lpPoints, short nCount)
{
    STACKWORDS(1+2+1);

    PUSH_WORD(hDC);
    PUSH_LPSTR(lpPoints);
    PUSH_WORD(nCount);
    return WINCALL( 37,GDI);
}

HGDIOBJ SelectObject(HDC hdc, HGDIOBJ obj)
{
    STACKWORDS(1+1);

    PUSH_WORD(hdc);
    PUSH_WORD(obj);
    return WINCALL(45,GDI);
}

HBITMAP CreateCompatibleBitmap(HDC hdc, short x, short y)
{
    STACKWORDS(1+1+1);

    PUSH_WORD(hdc);
    PUSH_WORD(x);
    PUSH_WORD(y);
    return WINCALL( 51,GDI);
}

HDC CreateCompatibleDC(HDC hdc)
{
    STACKWORDS(1);

    PUSH_WORD(hdc);
    return WINCALL( 52,GDI);
}

HFONT CreateFontIndirect (const LOGFONT FAR *lpLogFont)
{
    STACKWORDS(2);

    PUSH_LPSTR(lpLogFont);
    return WINCALL( 57,GDI);
}

HPEN CreatePen(short p1, short p2, COLORREF l)
{
    STACKWORDS(1+1+2);

    PUSH_WORD(p1);
    PUSH_WORD(p2);
    PUSH_LONG(l);
    return WINCALL( 61,GDI);
}

HBRUSH CreateSolidBrush(COLORREF attrib)
{
    STACKWORDS(2);

    PUSH_LONG(attrib);
    return WINCALL(66,GDI);
}

BOOL DeleteObject(HGDIOBJ obj)
{
    STACKWORDS(1);

    PUSH_WORD(obj);
    return WINCALL(69,GDI);
}

short EnumFonts(HDC hdc, LPCSTR face_name, OLDFONTENUMPROC callback_32, LPSTR data)
{
    STACKWORDS(1+2+2+2);
    ULONG cb16 = SV_CALL(M_LOAD_ENUMFONTS, (ULONG)callback_32);

    PUSH_WORD(hdc);
    PUSH_LPSTR(face_name);
    PUSH_LONG(cb16);
    PUSH_LPSTR(data);
    return WINCALL( 70,GDI);
}

HGDIOBJ GetStockObject(short att)
{
    STACKWORDS(1);

    PUSH_WORD(att);
    return WINCALL(87,GDI);
}

short GetDeviceCaps(HDC hdc, short att)
{
    STACKWORDS(1+1);

    PUSH_WORD(hdc);
    PUSH_WORD(att);
    return WINCALL(80,GDI);
}

BOOL GetTextMetrics (HDC hdc, TEXTMETRIC FAR *lpMetrics)
{
	STACKWORDS(1+2);
	PUSH_WORD(hdc);
	PUSH_LPSTR(lpMetrics);
	return WINCALL( 93,GDI);
}

short MulDiv(short x, short y, short z)
{
    STACKWORDS(1+1+1);

    PUSH_WORD(x);
    PUSH_WORD(y);
    PUSH_WORD(z);
    return WINCALL(128,GDI);
}


/* --------not tested ------------*/
/* --------not tested ------------*/
/* --------not tested ------------*/
/* --------not tested ------------*/

HDC CreateDC (LPCSTR lpDriver, LPCSTR lpDevice, LPCSTR lpOutput, const void FAR* lpData)
{
    STACKWORDS(2+2+2+2);

    PUSH_LPSTR(lpDriver);
    PUSH_LPSTR(lpDevice);
    PUSH_LPSTR(lpOutput);
    PUSH_LPSTR(lpData);
    return WINCALL( 53,GDI);
}

HFONT CreateFont (short par1, short par2, short par3, short par4, short par5, BYTE par6, BYTE par7, BYTE par8, BYTE par9, BYTE par10, BYTE par11, BYTE par12, BYTE par13, LPCSTR par14)
{
    STACKWORDS(1+1+1+1+1+1+1+1+1+1+1+1+1+2);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_WORD(par3);
    PUSH_WORD(par4);
    PUSH_WORD(par5);
    PUSH_WORD(par6);
    PUSH_WORD(par7);
    PUSH_WORD(par8);
    PUSH_WORD(par9);
    PUSH_WORD(par10);
    PUSH_WORD(par11);
    PUSH_WORD(par12);
    PUSH_WORD(par13);
    PUSH_LPSTR(par14);
    return WINCALL( 56,GDI);
}

BOOL DeleteDC (HDC par1)
{
    STACKWORDS(1);

    PUSH_WORD(par1);
    return WINCALL( 68,GDI);
}
short Escape (HDC par1, short par2, short par3, LPCSTR par4, void far *par5)
{
    STACKWORDS(1+1+1+2+2);
    ULONG cb16;

    /* check callback */
    if (par2 == SETABORTPROC)
	cb16 = SV_CALL(M_LOAD_ESCAPEABORT, (ULONG)par4);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_WORD(par3);
    if (par2 == SETABORTPROC) {
	PUSH_LONG(cb16);
    }
    else {
	PUSH_LPSTR(par4);
    }
    PUSH_LPSTR(par5);
    return WINCALL( 38,GDI);
}
short SetBkMode (HDC par1, short par2)
{
    STACKWORDS(1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    return WINCALL(  2,GDI);
}
short SetMapMode (HDC par1, short par2)
{
    STACKWORDS(1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    return WINCALL(  3,GDI);
}
DWORD SetViewportOrg (HDC par1, short par2, short par3)
{
    STACKWORDS(1+1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_WORD(par3);
    return WINCALL( 13,GDI);
}
DWORD SetViewportExt (HDC par1, short par2, short par3)
{
    STACKWORDS(1+1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_WORD(par3);
    return WINCALL( 14,GDI);
}
DWORD SetWindowExt (HDC par1, short par2, short par3)
{
    STACKWORDS(1+1+1);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_WORD(par3);
    return WINCALL( 12,GDI);
}
void LineDDA (short par1, short par2, short par3, short par4, LINEDDAPROC cb32, LPARAM data)
{
    STACKWORDS(1+1+1+1+2+2);
    ULONG cb16 = SV_CALL(M_LOAD_LINEDDA, (ULONG)cb32);

    PUSH_WORD(par1);
    PUSH_WORD(par2);
    PUSH_WORD(par3);
    PUSH_WORD(par4);
    PUSH_LONG(cb16);
    PUSH_LONG((ULONG)data);
    WINCALL(100,GDI);
}

